// Lab10: Design the controller for a given system using 
// variable structure control scheme.


//              scilab - 5.5.1
//              Operating System : Windows 7, 32-bit
//------------------------------------------------------------------------

//Clean the environment
xdel(winsid());//close all graphics Windows clear ;
clear;
clc ;

//------------------------------------------------------------------------

//system dicription
xi=0.7;
alpha=1;
c=-xi/2+sqrt(xi^2/4+alpha)

//------------------------------------------------------------------------

//Simulation
importXcosDiagram("Lab10.xcos")
xcos_simulate(scs_m,4);
scs_m.props.context

//------------------------------------------------------------------------

//State responses
figure,
plot(x1.time,x1.values,2);
plot(x2.time,x2.values,'r--');
//Title, labels and grid to the figure
exec .\fig_settings.sci; // custom script for setting figure properties
title('State responses of the system with VSC','fontsize',3)
xlabel("$t sec.$",'fontsize',3);
ylabel ("$x_1(t),\,x_2(t)$", 'fontsize',3);
h=legend("Oen loop","Closed loop",1);
h.font_size=2;
h.fill_mode='off'

//------------------------------------------------------------------------

//State trajectory
figure,
plot(x1.values,x2.values);
//Title, labels and grid to the figure
exec .\fig_settings.sci; // custom script for setting figure properties
title('State trajectory of the system with VSC','fontsize',3)
xlabel("$x_1$",'fontsize',3);
ylabel ("$x_2$", 'fontsize',3);
f=gca();
f.x_location = "origin"
f.y_location = "origin"

//------------------------------------------------------------------------
